/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard;

import com.finallion.graveyard.client.TheGraveyardClient;
import com.finallion.graveyard.config.GraveyardConfig;
import com.finallion.graveyard.init.TGConfiguredStructureFeatures;
import com.finallion.graveyard.init.TGParticles;
import com.finallion.graveyard.init.TGStructures;
import com.finallion.graveyard.init.TGTileEntities;
import com.finallion.graveyard.structures.processors.SimpleSurfaceProcessors;
import com.finallion.graveyard.utils.ProcessorRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="graveyard")
public class TheGraveyard {
    public static final String MOD_ID = "graveyard";
    private static Method GETCODEC_METHOD;
    public static final IStructureProcessorType<SimpleSurfaceProcessors> SIMPLE_SURFACE_PROCESSOR;
    public static final StructureProcessorList SIMPLE_SURFACE_LIST;
    public static final ItemGroup GROUP;

    public TheGraveyard() {
        GeckoLib.initialize();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> TheGraveyardClient::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::setup);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        TGStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        TGTileEntities.TILE_ENTITIES.register(modEventBus);
        TGParticles.PARTICLES.register(modEventBus);
        GraveyardConfig.loadConfig(GraveyardConfig.COMMON_SPEC, FMLPaths.CONFIGDIR.get().resolve("graveyard-common.toml"));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, GraveyardConfig.COMMON_SPEC);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TGStructures.register();
            TGConfiguredStructureFeatures.registerConfiguredStructures();
        });
    }

    public void biomeModification(BiomeLoadingEvent event) {
        TheGraveyard.putStructures(event);
    }

    public static void putStructures(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        switch (category) {
            case PLAINS: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_WALLED_GRAVEYARD, GraveyardConfig.INSTANCE.ENABLE_SMALL_GRAVEYARD);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_GRAVE, GraveyardConfig.INSTANCE.ENABLE_GRAVE);
                break;
            }
            case SAVANNA: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_WALLED_GRAVEYARD_SAVANNA, GraveyardConfig.INSTANCE.ENABLE_SMALL_GRAVEYARD_SAVANNA);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_SAVANNA_GRAVE, GraveyardConfig.INSTANCE.ENABLE_SAVANNA_GRAVE);
                break;
            }
            case MESA: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_SAVANNA_GRAVE, GraveyardConfig.INSTANCE.ENABLE_SAVANNA_GRAVE);
                break;
            }
            case EXTREME_HILLS: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_MOUNTAIN_GRAVE, GraveyardConfig.INSTANCE.ENABLE_MOUNTAIN_GRAVE);
                break;
            }
            case FOREST: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_GRAVE, GraveyardConfig.INSTANCE.ENABLE_GRAVE);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_LARGE_WALLED_GRAVEYARD, GraveyardConfig.INSTANCE.ENABLE_LARGE_GRAVEYARD);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_MEDIUM_WALLED_GRAVEYARD, GraveyardConfig.INSTANCE.ENABLE_MEDIUM_GRAVEYARD);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_LARGE_BIRCH_TREE, GraveyardConfig.INSTANCE.ENABLE_BIRCH_TREE);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_HAUNTED_HOUSE, GraveyardConfig.INSTANCE.ENABLE_HAUNTED_HOUSE);
                break;
            }
            case TAIGA: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_GRAVE, GraveyardConfig.INSTANCE.ENABLE_GRAVE);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_LARGE_WALLED_GRAVEYARD, GraveyardConfig.INSTANCE.ENABLE_LARGE_GRAVEYARD);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_MEDIUM_WALLED_GRAVEYARD, GraveyardConfig.INSTANCE.ENABLE_MEDIUM_GRAVEYARD);
                break;
            }
            case MUSHROOM: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_MUSHROOM_GRAVE, GraveyardConfig.INSTANCE.ENABLE_MUSHROOM_GRAVE);
                break;
            }
            case DESERT: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_WALLED_GRAVEYARD_DESERT, GraveyardConfig.INSTANCE.ENABLE_SMALL_GRAVEYARD_DESERT);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_SMALL_DESERT_GRAVE, GraveyardConfig.INSTANCE.ENABLE_DESERT_GRAVE);
                break;
            }
            case JUNGLE: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_MUSHROOM_GRAVE, GraveyardConfig.INSTANCE.ENABLE_MUSHROOM_GRAVE);
                break;
            }
            case SWAMP: {
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_MUSHROOM_GRAVE, GraveyardConfig.INSTANCE.ENABLE_MUSHROOM_GRAVE);
                TheGraveyard.add(event, TGConfiguredStructureFeatures.CONFIGURED_HAUNTED_HOUSE, GraveyardConfig.INSTANCE.ENABLE_HAUNTED_HOUSE);
                break;
            }
        }
    }

    public static void add(BiomeLoadingEvent e, StructureFeature<?, ?> s, boolean config) {
        if (config) {
            e.getGeneration().getStructures().add(Lazy.of(() -> s));
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (!serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception cgRL) {
                // empty catch block
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(TGStructures.SMALL_WALLED_GRAVEYARD.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TGStructures.SMALL_WALLED_GRAVEYARD.get()));
            tempMap.putIfAbsent(TGStructures.SMALL_WALLED_GRAVEYARD_DESERT.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TGStructures.SMALL_WALLED_GRAVEYARD_DESERT.get()));
            tempMap.putIfAbsent(TGStructures.SMALL_WALLED_GRAVEYARD_SAVANNA.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TGStructures.SMALL_WALLED_GRAVEYARD_SAVANNA.get()));
            tempMap.putIfAbsent(TGStructures.MEDIUM_WALLED_GRAVEYARD.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TGStructures.MEDIUM_WALLED_GRAVEYARD.get()));
            tempMap.putIfAbsent(TGStructures.LARGE_WALLED_GRAVEYARD.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TGStructures.LARGE_WALLED_GRAVEYARD.get()));
            tempMap.putIfAbsent(TGStructures.LARGE_BIRCH_TREE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TGStructures.LARGE_BIRCH_TREE.get()));
            tempMap.putIfAbsent(TGStructures.MUSHROOM_GRAVE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TGStructures.MUSHROOM_GRAVE.get()));
            tempMap.putIfAbsent(TGStructures.MUSHROOM_GRAVE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TGStructures.MUSHROOM_GRAVE.get()));
            tempMap.putIfAbsent(TGStructures.HAUNTED_HOUSE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TGStructures.HAUNTED_HOUSE.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    static {
        SIMPLE_SURFACE_PROCESSOR = IStructureProcessorType.func_237139_a_((String)"simple_surface_processor", SimpleSurfaceProcessors.CODEC);
        SIMPLE_SURFACE_LIST = ProcessorRegistry.registerStructureProcessor("simple_surface_list", (ImmutableList<StructureProcessor>)ImmutableList.of((Object)((Object)new SimpleSurfaceProcessors())));
        GROUP = new ItemGroup("group"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)Items.field_196182_dv);
            }
        };
    }
}

